/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartPart;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.ClickCallbackGenerator;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Callback;
import com.roguewave.chart.core.v2_1.graphics.ClickablePolygon;
import com.roguewave.chart.core.v2_1.graphics.ColorArray;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeInternal;
import com.roguewave.chart.core.v2_1.graphics.SortTreeLeaf;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.AreaSegment;
import java.awt.Color;

public class AreaChartStack
extends ChartPart {
    public AreaChartStack(ChartProperties properties, DataModel data, int leftColumn, Transform3D transform, double depth, ColorArray colors) {
        ClickCallbackGenerator generator = properties.getClickCallbackGenerator();
        int rows = data.getRowCount();
        int columns = data.getColumnCount();
        double x = -((double)columns - 1.0) / 2.0;
        double lastLeft = 0.0;
        double lastRight = 0.0;
        double leftValue = properties.getScaledValue(data, 0, leftColumn);
        double rightValue = properties.getScaledValue(data, 0, leftColumn + 1);
        Color color = properties.getColor(0, leftColumn, colors.color(0), leftValue);
        AreaSegment segment = new AreaSegment(lastLeft, lastRight, leftValue, rightValue, depth, transform, color);
        if (generator == null) {
            this.add2DPolygons(segment.front());
        } else {
            int[] rowArr = new int[]{0, 0};
            int[] colArr = new int[]{leftColumn, leftColumn + 1};
            Callback callback = generator.generateCallback(data, rowArr, colArr);
            this.add2DClickable(new ClickablePolygon(segment.front()[0].zeroZ(), callback));
        }
        lastLeft = leftValue;
        lastRight = rightValue;
        SortTreeNode stnPrevious = this.createSortTreeNode(data, 0, leftColumn, segment, generator);
        for (int row = 1; row < rows; ++row) {
            leftValue = lastLeft + properties.getScaledValue(data, row, leftColumn);
            rightValue = lastRight + properties.getScaledValue(data, row, leftColumn + 1);
            color = properties.getColor(row, leftColumn, colors.color(row), leftValue);
            segment = new AreaSegment(lastLeft, lastRight, leftValue, rightValue, depth, transform, color);
            if (generator == null) {
                this.add2DPolygons(segment.front());
            } else {
                int[] rowArr = new int[]{row, row};
                int[] colArr = new int[]{leftColumn, leftColumn + 1};
                Callback callback = generator.generateCallback(data, rowArr, colArr);
                this.add2DClickable(new ClickablePolygon(segment.front()[0].zeroZ(), callback));
            }
            SortTreeNode stnNew = this.createSortTreeNode(data, row, leftColumn, segment, generator);
            Point3D[] testPoints = new Point3D[]{transform.transform(new Point3D(0.0, lastLeft, 0.5 - depth / 2.0)), transform.transform(new Point3D(1.0, lastRight, 0.5 - depth / 2.0)), transform.transform(new Point3D(0.0, lastLeft, 0.5 + depth / 2.0))};
            stnPrevious = new SortTreeInternal(stnPrevious, stnNew, testPoints);
            lastLeft = leftValue;
            lastRight = rightValue;
        }
        this.setSortTree(stnPrevious);
    }

    private SortTreeNode createSortTreeNode(DataModel data, int row, int column, AreaSegment segment, ClickCallbackGenerator generator) {
        SortTreeLeaf node;
        if (generator == null) {
            node = new SortTreeLeaf(segment.polygons());
        } else {
            node = new SortTreeLeaf();
            int[] rowArr = new int[]{row, row};
            int[] colArr = new int[]{column, column + 1};
            Callback callback = generator.generateCallback(data, rowArr, colArr);
            Polygon3D[] polygons = segment.polygons();
            for (int i = 0; i < polygons.length; ++i) {
                node.addClickable(new ClickablePolygon(polygons[i], callback));
            }
        }
        return node;
    }
}

